package displaytable;

import java.util.*;
import javax.swing.table.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */
public class DynamicallyModifiableTableModel extends AbstractTableModel {
    //--- In a real app, we'd probably want this to be thread safe
    //--- and so would either use the Collections static class to make it synchronized
    //--- or else we'd use something synchronized like a Vector
    protected ArrayList columnNames = new ArrayList();
    protected ArrayList rows = new ArrayList();


    public void addColumn(String name) {
        columnNames.add(name);
        this.fireTableStructureChanged();
    }

    public void addRow(ArrayList row) {
        try {
            ArrayList newRow = (ArrayList) row.clone();
            rows.add(newRow);
            int rowNumber = rows.size();
            this.fireTableRowsInserted(rowNumber,rowNumber);
        }
        catch(Exception exception) {
            exception.printStackTrace();
        }
    }  //--- addRow

    public void reset() {
        columnNames.clear();
        rows.clear();
        this.fireTableStructureChanged();
    }

    public void setColumnName(int column, String columnName) {
        try {
            columnNames.set(column,columnName);
            this.fireTableDataChanged();
        }
        catch(Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * This is destructive - it wipes out any data you once had
     */
    public void setColumnNames(ArrayList names) {
        try {
            columnNames = (ArrayList) names.clone();
            this.fireTableDataChanged();
        }
        catch(Exception exception) {
            exception.printStackTrace();
        }
    }  //--- setColumnNames


    /*
     * This is destructive - it wipes out any data you once had
     */
    public void setNumberOfColumns(int numberOfColumns) {
        ArrayList columns = new ArrayList();
        for (int i=0; i < numberOfColumns; i++) {
            columns.add("");
        }
        setColumnNames( columns );
    }  //--- setNumberOfColumns

    /*
     * This is destructive - it wipes out any data you once had
     */
    public void setNumberOfColumns(int numberOfColumns,
                                   boolean showColumnHeader) {
        ArrayList columns = new ArrayList();
        for (int i=0; i < numberOfColumns; i++) {
            if (showColumnHeader) {
                //--- Set the column header to a single space
                //--- It won't display as anything, but it will force
                //---   the column header to be drawn
                columns.add(" ");
            } else {
                //--- JScrollPane won't draw the JTable column header
                //--- if it finds an empty string
                columns.add("");
            }
        }
        setColumnNames( columns );
    }  //--- setNumberOfColumns

    /*
     * This is destructive - it wipes out any data you once had
     */
    public void setNumberOfRows(int numberOfRows) {
        ArrayList blankRow = new ArrayList();
        for (int j=0; j < columnNames.size(); j++) {
            blankRow.add("");
        }

        rows = new ArrayList();
        for (int i=0; i < numberOfRows; i++) {
            ArrayList newRow = (ArrayList) blankRow.clone();
            rows.add(newRow);
        }

        this.fireTableStructureChanged();
    }  //--- setNumberOfRows


    public int getColumnCount() {
        try {
            return columnNames.size();
        }
        catch(java.lang.NullPointerException exception) {
            return 0;
        }
    }  //--- getColumnCount


    public int getRowCount() {
        try {
            return rows.size();
        }
        catch(java.lang.NullPointerException exception) {
            return 0;
        }
    }  //--- getRowCount


    public String getColumnName(int col) {
        return columnNames.get(col).toString();
    }  //--- getColumnName


    public Object getValueAt(int row, int col) {
        Object value = null;
        try {
            ArrayList aRow = (ArrayList) rows.get(row);
            value = aRow.get(col);
        }
        catch(Exception exception) {
            exception.printStackTrace();
        }

        return value;
    }  //--- getValueAt

    /*
     * JTable uses this method to determine the default renderer/
     * editor for each cell.  If we didn't implement this method,
     * then the last column would contain text ("true"/"false"),
     * rather than a check box.
     */
    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }


    /*
     * Don't need to implement this method unless your table's
     * data can change.
     */
    public void setValueAt(Object value, int row, int col) {
        ArrayList aRow = (ArrayList) rows.get(0);
        if (aRow.get(col) instanceof Integer
            && !(value instanceof Integer)) {
            //With JFC/Swing 1.1 and JDK 1.2, we need to create
            //an Integer from the value; otherwise, the column
            //switches to contain Strings.  Starting with v 1.3,
            //the table automatically converts value to an Integer,
            //so you only need the code in the 'else' part of this
            //'if' block.
            //XXX: See TableEditDemo.java for a better solution!!!
            try {
                ArrayList tempRow = (ArrayList) rows.get(row);
                tempRow.set(col, new Integer(value.toString()));
                fireTableCellUpdated(row, col);
            } catch (NumberFormatException e) {
                //--- do nothing
            }
        } else {
            ArrayList tempRow = (ArrayList) rows.get(row);
            tempRow.set(col, value);
            fireTableCellUpdated(row, col);
        }
    }  //--- setValueAt

}  //--- DynamicallyModifiableTableModel