package pcshoppingassistant;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import net.sourceforge.selectionengine.*;
//import temp.*;


/**
 * Title:        PCShoppingAssistant
 * Description:  This Java application assists customers shopping for personal computers at a fictional computer retailer.
 * There are several goals for this project. The first is to build a sample application illustrating the use of The SelectionEngine, a set of Java case based reasoning (CBR) components written by baylor wetzel and provided as open source software at http://selectionengine.sourceforge.net. The second goal is to analyze the functional needs of a real world application as it relates to CBR and to verify that the SelectionEngine CBR system provides the needed functions. That is, the SelectionEngine CBR system was tailored to the application's needs rather than creating an application based on the tool's capabilities. Third, this application is intended to show how CBR can be used in real world applications. The focus of this goal is to show that CBR is easy to use, easy to understand, makes sense for every day applications and is not the difficult, specialized, exotic technology that most business developers believe all AI technologies to be. The fourth goal is to show how AI can be used in the retail world
 * This application was created by baylor wetzel, computer science MS student, for CSIS 636T Artificial Intelligence and Expert Systems II, Fall 2001, University of St Thomas Graduate Programs in Software.
 * Copyright:    Copyright (c) 2001
 * Company:      University of St Thomas
 * @author baylor wetzel
 * @version 1.0
 */

public class BatchWindow extends JFrame {
    JButton searchButton = new JButton();

    JTabbedPane tabbedPane = new JTabbedPane();
    JScrollPane dataScrollPane = new JScrollPane();
    JScrollPane queryScrollPane = new JScrollPane();
    JScrollPane traitDescriptorsScrollPane = new JScrollPane();
    JScrollPane resultsScrollPane = new JScrollPane();
    JTextArea queryTextArea = new JTextArea();
    JTextArea outputTextArea = new JTextArea();
    JScrollPane dataBreakdownHTMLScrollPane = new JScrollPane();
    JLabel dataBreakdownHTMLLabel = new JLabel();
    JEditorPane resultsEditorPane = new JEditorPane();
    JLabel dataHTMLLabel = new JLabel();


    public BatchWindow() {
        try {
            jbInit();
//            WindowUtilities.setNativeLookAndFeel();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }  //--- constructor

    private void jbInit() throws Exception {
        searchButton.setText("Start");
        searchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                searchButton_actionPerformed(e);
            }
        });
        this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        this.setTitle("PC Shopping Assistant");
        dataBreakdownHTMLLabel.setBackground(Color.white);
        dataBreakdownHTMLLabel.setFont(new java.awt.Font("Monospaced", 0, 12));
        dataBreakdownHTMLLabel.setOpaque(true);
        dataBreakdownHTMLLabel.setVerticalAlignment(SwingConstants.TOP);
        resultsEditorPane.setEditable(false);
        resultsEditorPane.setContentType("text/html");
        dataHTMLLabel.setBackground(Color.white);
        dataHTMLLabel.setFont(new java.awt.Font("Monospaced", 0, 12));
        dataHTMLLabel.setOpaque(true);
        dataHTMLLabel.setVerticalAlignment(SwingConstants.TOP);
        this.getContentPane().add(searchButton, BorderLayout.SOUTH);
        this.getContentPane().add(tabbedPane, BorderLayout.CENTER);


        queryTextArea.setMargin(new Insets(5, 5, 5, 5));
        queryTextArea.setEditable(false);
        queryTextArea.setFont(new java.awt.Font("Monospaced", 0, 12));

        outputTextArea.setLineWrap(true);
        outputTextArea.setMargin(new Insets(5, 5, 5, 5));
        outputTextArea.setEditable(false);
        outputTextArea.setFont(new java.awt.Font("Monospaced", 0, 12));

        tabbedPane.add(dataScrollPane, "Data");
        dataScrollPane.getViewport().add(dataHTMLLabel, null);
        tabbedPane.add(queryScrollPane, "Query");
        tabbedPane.add(dataBreakdownHTMLScrollPane, "Data Breakdown HTML");
        dataBreakdownHTMLScrollPane.getViewport().add(dataBreakdownHTMLLabel, null);
        tabbedPane.add(traitDescriptorsScrollPane, "Work");
        tabbedPane.add(resultsScrollPane, "Results");
        resultsScrollPane.getViewport().add(resultsEditorPane, null);

        queryScrollPane.getViewport().add(queryTextArea, null);
        traitDescriptorsScrollPane.getViewport().add(outputTextArea, null);
    }

    void searchButton_actionPerformed(ActionEvent e) {
        try {
            MatchingItemsManager matchingItemsManager = new MatchingItemsManager();
            matchingItemsManager.load();

            TraitDescriptors traitDescriptors = matchingItemsManager.getTraitDescriptors();
            FilterCriteria filterCriteria = matchingItemsManager.getQueryManager().getFilterCriteria();
            Items items = matchingItemsManager.getItems();
            Items filteredItems = matchingItemsManager.getFilteredItems();
            SimilarItems similarItems = matchingItemsManager.getSimilarItems();
            SimilarityCriteria sc = matchingItemsManager.getSimilarityCriteria();
            SimilarityWeights sw = matchingItemsManager.getSimilarityWeights();

            displayTraitDescriptors( outputTextArea, traitDescriptors );
            displayItems( dataHTMLLabel, items );
            displayDataBreakdown( items );
            displayFilterCriteria( queryTextArea, filterCriteria );
            displayFilteredItems( outputTextArea, filteredItems );
            displaySimilarityCriteria( queryTextArea, sc );
            displaySimilarityWeights( queryTextArea, sw );
            displaySimilarItems( resultsEditorPane, traitDescriptors, similarItems );
        }
        catch( Exception exception) {
            System.out.println( "Exception: " + exception );
        }
    }  //--- searchButton_actionPerformed


    /*
     * Yet another attempt to find a decent way to display data in Java
     * Caveats:
     *  - only works in JDK 1.2.2 or later, or in Swing 1.1.1 or later
     *  - Label string must begin with "<html>", not "<HTML>"
     *  - <img> tag doesn't work
     *  - <br> tag doesn't work
     */
    public void displayDataBreakdown( Items items ) {
        try {
            StringBuffer HTML = new StringBuffer();

            String HTMLHeader = "<html>";
            String HTMLFooter = "</html>";
            String tableHeader = "<table border=0>";
            String tableFooter = "</table>";
            String rowHeader = "<tr valign=top>";
            String rowFooter = "</tr>";
            String nextRowTag = rowFooter + rowHeader;
            String cellHeader = "<td>";
            String cellFooter = "</td>";
            String newCellTag = cellFooter + cellHeader;

            String columnHeader = "<td bgcolor=gray color=black colspan=3><center><b>";
            String columnFooter = "</b></center></td>";
            String bufferColumn = "<td>&nbsp;</td>";
            String headerBufferColumn = "<td>&nbsp;</td>";


            //--- Get data breakdown statistics. That means, for each
            //---   trait/property/attribute/whatever an item might have,
            //---   figure out the min, max and where items fall along that spectrum
            DataBreakdownForTraits dataBreakdownForTraits =
                new DataBreakdownForTraits(items);
            //--- Put the names of the traits in a TreeSet. Why? Because TreeSets
            //---   are automatically sorted, and we want to display the data in
            //---   alphabetical order. DataBreakdownForTraits stores the data in
            //---   a HashMap, which can't be sorted, thus our use of the TreeSet
            Set sortedTraitNames = new TreeSet(dataBreakdownForTraits.getDataBreakdowns().keySet());


            //--- We need to know how many traits we have and what the longest
            //---   set of traits is, 'cause those will be the number of columns
            //---   and rows for our table
            int numCols = sortedTraitNames.size() * 3;  //--- -1 'cause 0 indexed?
            int numRows = 0;
            Iterator traitNamesIterator = sortedTraitNames.iterator();
            while (traitNamesIterator.hasNext()) {
                String traitName = (String) traitNamesIterator.next();

                //--- Get the DataBreakdownForTrait for this trait
                DataBreakdownForTrait traitBreakdown =
                    dataBreakdownForTraits.getDataBreakdown(traitName);
                int currentColumnLength = traitBreakdown.getBreakPoints().size();
                if (currentColumnLength > numRows) {
                    numRows = currentColumnLength;
                }
            }

            //--- We need some place to hold our data
            //--- Why? Because HTML arrays are built left to right and then
            //---   top down (<td> before <tr>). That makes writing a loop to
            //---   build the HTML using collection iterators a pain,
            //---   so we're gonna store all the data temporarily in something
            //---   we can loop through nicely
            String tableData[][] = new String[numCols][numRows];


            //--- Let's go through each trait, in alphabetical order
            //---   and add it to our table data array
            traitNamesIterator = sortedTraitNames.iterator();
            int currentColumn = 0;
            while (traitNamesIterator.hasNext()) {
                String traitName = (String) traitNamesIterator.next();

                //--- Get the DataBreakdownForTrait for this trait
                DataBreakdownForTrait traitBreakdown =
                    dataBreakdownForTraits.getDataBreakdown(traitName);

                //--- Get the name, value and frequency of each break point
                Set sortedBreakPointKeys = new TreeSet(traitBreakdown.getBreakPoints().keySet());
                Iterator breakPointKeysIterator = sortedBreakPointKeys.iterator();
                int currentRow = 0;
                while (breakPointKeysIterator.hasNext()) {
                    String key = (String) breakPointKeysIterator.next();
                    BreakPoint breakPoint = traitBreakdown.getBreakPoint(key);

                    int dataType = items.getTraitDescriptors().getDataType(traitName);
                    if ((dataType==TraitDescriptor.TYPE_FLOAT)||
                        (dataType==TraitDescriptor.TYPE_INTEGER))  {
                        String temp = "<right>" +
                                      breakPoint.getName() +
                                      "%</right>";
                        tableData[currentColumn][currentRow] = temp;
                    } else {
                        tableData[currentColumn][currentRow] = "";
                    }

                    if (breakPoint.getCount()>0) {
                        String count = breakPoint.getValue();
                        if ((dataType==TraitDescriptor.TYPE_FLOAT)||
                            (dataType==TraitDescriptor.TYPE_INTEGER))  {
                            float precisionValue = Float.parseFloat(count);
                            precisionValue = Math.round(precisionValue * 100);
                            precisionValue /= 100;
                            count = "<right>" + Float.toString(precisionValue) + "</right>";
                        }
                        tableData[currentColumn+1][currentRow] = count;

                        int c = breakPoint.getCount(), t = traitBreakdown.getDataSetSize();
                        float fc = c, ft = t;
                        float floatPercent = fc/ft;
                        floatPercent *= 100;
                        int percent = Math.round(floatPercent);
                        String temp = "(" + breakPoint.getCount() +
                                      "/" + traitBreakdown.getDataSetSize() +
                                      " - " + percent + "%)";
                        tableData[currentColumn+2][currentRow] = temp;
                    }
                    currentRow++;
                }  //--- while there are more breakpoints for this trait
                currentColumn += 3;
            }  //--- there are more traits


            //--- Header
            HTML.append(HTMLHeader);
            HTML.append(tableHeader);

            //--- Column headers
            HTML.append(rowHeader);
            traitNamesIterator = sortedTraitNames.iterator();
            while (traitNamesIterator.hasNext()) {
                String traitName = (String) traitNamesIterator.next();
                HTML.append(columnHeader);
                HTML.append(traitName.toUpperCase());
                HTML.append(columnFooter);
                HTML.append(headerBufferColumn);
            }
            HTML.append(rowFooter);

            //--- Print off all the data in our data array
            for (int y=0; y<numRows; y++) {
                HTML.append(rowHeader);
                for (int x=0; x<numCols; x++) {
                    HTML.append(cellHeader);
                    String value = tableData[x][y];
                    if (value==null)
                        value = "";
                    HTML.append(value);
                    HTML.append(cellFooter);

                    //--- What a hack!
                    //--- Every fourth column is a buffer column
                    if ((x%3)==2)
                        HTML.append(bufferColumn);
                }
                HTML.append(rowFooter);
            }

            //--- Footer
            HTML.append(tableFooter);
            HTML.append(HTMLFooter);


            //--- Draw our HTML table on the screen
            dataBreakdownHTMLLabel.setText(HTML.toString());
        }
        catch(Exception e) {
            System.out.println(e);
        }
    }


    public void displayFilterCriteria( JTextArea displayBuffer,
                                       FilterCriteria filterCriteria ) {
        displayBuffer.append( "\n" );
        displayBuffer.append( "Filter Criteria (" + filterCriteria.size() + ")\n" );
        displayBuffer.append( "---------------\n" );

        Iterator cursor = filterCriteria.iterator();	//--- iterator on an ArrayList
        while (cursor.hasNext()) {
            FilterCriterion criterion = (FilterCriterion) cursor.next();
            String s = criterion.getFieldName() + " " +
                       criterion.getOperatorAsString() + " " +
                       criterion.getValue() + "\n";
            displayBuffer.append( s );
        }  //--- while hasNext
    }  //--- displayFilterCriteria


    public void displayFilteredItems( JTextArea displayBuffer, Items items ) {
        displayBuffer.append( "\n" );
        displayBuffer.append( "Items after filtering (" + items.size() + ")\n" );
        displayBuffer.append( "---------------------\n" );

        Iterator cursor = items.iterator();	//--- iterator on an ArrayList
                                            //---   filled with items
        TraitDescriptors traitDescriptors = items.getTraitDescriptors();

        //--- While we have more rows of data
        while (cursor.hasNext()) {
            //--- values is a HashMap that might look like
            //---   [string maker][compaq] [string model][proliant] etc.
            Item item = (Item) cursor.next();

            //--- Which trait should we print a value for?
            //--- Let's print all of them out in the same order as they're
            //---   stored in TraitDescriptors
            for (int i=0; i < traitDescriptors.size(); i++ ) {
                //--- What trait do we want to see the value for?
                TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                String traitName = traitDescriptor.getName();

                //--- Let's get that trait in the current item
                String value = item.getTraitValue( traitName ).value();
                displayBuffer.append( value );
                displayBuffer.append( "  " );
            }  //--- for i=0 to fields.size
            //--- New line for formatting purposes
            displayBuffer.append("\n");
        }  //--- while hasNext
    }  //--- displayItems


    public void displayItems( JLabel displayBuffer,
                              Items items ) {
        StringBuffer HTML = new StringBuffer();

        String HTMLHeader = "<html>";
        String HTMLFooter = "</html>";
        String tableHeader = "<table border=0>";
        String tableFooter = "</table>";
        String rowHeader = "<tr valign=top>";
        String rowFooter = "</tr>";
        String cellHeader = "<td>";
        String cellFooter = "</td>";
        String newCellTag = cellFooter + cellHeader;


        //--- Header
        HTML.append(HTMLHeader);
        HTML.append( "<b><u>Items (" + items.size() + ")</u></b><p>" );
        HTML.append(tableHeader);

//        displayBuffer.append( "\n" );
//        displayBuffer.append( "Items (" + items.size() + ")\n" );
//        displayBuffer.append( "-----\n" );

        Iterator cursor = items.iterator();	//--- iterator on an ArrayList
                                            //---   filled with items
        TraitDescriptors traitDescriptors = items.getTraitDescriptors();

        //--- While we have more rows of data
        while (cursor.hasNext()) {
            HTML.append(rowHeader);

            //--- values is a HashMap that might look like
            //---   [string maker][compaq] [string model][proliant] etc.
            Item item = (Item) cursor.next();

            //--- Which trait should we print a value for?
            //--- Let's print all of them out in the same order as they're
            //---   stored in TraitDescriptors
            for (int i=0; i < traitDescriptors.size(); i++ ) {
                //--- What trait do we want to see the value for?
                TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                String traitName = traitDescriptor.getName();

                //--- Let's get that trait in the current item
                String value = item.getTraitValue( traitName ).value();
                HTML.append(cellHeader);
                HTML.append( value );
                HTML.append(cellFooter);
//                displayBuffer.append( "  " );
            }  //--- for i=0 to fields.size
            //--- New line for formatting purposes
            HTML.append(rowFooter);
        }  //--- while hasNext

        //--- Footer
        HTML.append(tableFooter);
        HTML.append(HTMLFooter);

        displayBuffer.setText(HTML.toString());
    }  //--- displayItems


    /**
      * This is where we display ranked and sorted results
      */
    public void displaySimilarItems( JEditorPane displayBuffer,
                                     TraitDescriptors traitDescriptors,
                                     SimilarItems items ) {
        try {
            StringBuffer HTML = new StringBuffer();

            HTML.append("<table border=0 cellspacing=0 cellpadding=3>");

            //--- Column headers
            HTML.append("<tr>");
            HTML.append("<th><u>Rank</u></th><th><u>Similarity</u></th>");
            for (int i=0; i < traitDescriptors.size(); i++ ) {
                //--- What trait do we want to see the value for?
                TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                String traitName = traitDescriptor.getName();

                String align = "";
                switch (traitDescriptor.getDataType()) {
                    case TraitDescriptor.TYPE_BOOLEAN:
                        align = "align=center";
                        break;
                    case TraitDescriptor.TYPE_STRING:
                        align = "align=left";
                        break;
                    case TraitDescriptor.TYPE_INTEGER:
                    case TraitDescriptor.TYPE_FLOAT:
                        align = "align=right";  //--- could sprintf for formatting
                        break;
                }

                HTML.append("<th " + align + "><u>");
                HTML.append( traitName );
                HTML.append("</u></th>");
            }  //--- for i=0 to fields.size
            HTML.append("</tr>");


            //--- Print off each item
            Iterator cursor = items.iterator();
            while (cursor.hasNext()) {
                SimilarityDescription similarityDescription =
                    (SimilarityDescription) cursor.next();
                int percentSimilarity =
                    (int) (100 * similarityDescription.getPercentSimilarity());
                int rank = similarityDescription.getRank();
                Item item = similarityDescription.getItem();

                HTML.append("<tr>");

                HTML.append("<td>");
                HTML.append( rank + ". " );
                HTML.append("</td>");
                HTML.append("<td align=right>");
                HTML.append( percentSimilarity + "%" );
                HTML.append("</td>");

                //--- Which trait should we print a value for?
                //--- Let's print all of them out in the same order as they're
                //---   stored in TraitDescriptors
                for (int i=0; i < traitDescriptors.size(); i++ ) {
                    //--- What trait do we want to see the value for?
                    TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                    String traitName = traitDescriptor.getName();

                    String align = "";
                    switch (traitDescriptor.getDataType()) {
                        case TraitDescriptor.TYPE_BOOLEAN:
                            align = "align=center";
                            break;
                        case TraitDescriptor.TYPE_STRING:
                            align = "align=left";
                            break;
                        case TraitDescriptor.TYPE_INTEGER:
                        case TraitDescriptor.TYPE_FLOAT:
                            align = "align=right";  //--- could sprintf for formatting
                            break;
                    }

                    //--- Let's get that trait in the current item
                    String value = item.getTraitValue( traitName ).value();

                    HTML.append("<td " + align + ">");
                    HTML.append( value );
                    HTML.append("</td>");
                }  //--- for i=0 to fields.size

                HTML.append( "</tr>" );
            }  //--- while hasNext
            HTML.append("</table>");


            //--- Show our results
            displayBuffer.setText(HTML.toString());
        }
        catch (Exception e) {
            System.out.println( "Exception: " + e );
            e.printStackTrace();
        }  //--- catch
    }  //--- displaySimilarItems


    public void displayTraitDescriptors( JTextArea displayBuffer,
                                         TraitDescriptors traitDescriptors ) {
        displayBuffer.append( "\n" );
        displayBuffer.append( "Trait Descriptors (" + traitDescriptors.size() + ")\n" );
        displayBuffer.append( "-----------------\n" );

        Iterator cursor = traitDescriptors.iterator();	//--- iterator on an ArrayList
        while (cursor.hasNext()) {
            String field = cursor.next().toString();

            displayBuffer.append( field );
            displayBuffer.append( "  " );
        }  //--- while hasNext
        displayBuffer.append( "\n" );
    }  //--- displayTraitDescriptors

    public void displaySimilarityCriteria( JTextArea displayBuffer,
                                           SimilarityCriteria similarityCriteria ) {
        displayBuffer.append( "\n" );
        displayBuffer.append( "SimilarityCriteria (" + similarityCriteria.size() + ")\n" );
        displayBuffer.append( "------------------\n" );

        Iterator cursor = similarityCriteria.iterator();	//--- iterator on an ArrayList
        while (cursor.hasNext()) {
            SimilarityCriterion criterion = (SimilarityCriterion) cursor.next();

            displayBuffer.append( criterion.getFieldName() );
            displayBuffer.append( " " );
            displayBuffer.append( criterion.getOperatorAsString() );
            displayBuffer.append( " " );
            displayBuffer.append( criterion.getValue().toString() + "\n" );
        }  //--- while hasNext
    }  //--- displaySimilarityCriteria

    public void displaySimilarityWeights( JTextArea displayBuffer,
                                          SimilarityWeights similarityWeights ) {
        displayBuffer.append( "\n" );
        displayBuffer.append( "SimilarityWeights (" + similarityWeights.size() + ")\n" );
        displayBuffer.append( "-----------------\n" );

        Iterator cursor = similarityWeights.mapIterator();
        while (cursor.hasNext()) {
            //--- We're using the mapIterator because the normal iterator
            //---   will just return us an Integer, and we want the trait name too
            Map.Entry weight = (Map.Entry) cursor.next();

            displayBuffer.append( weight.getKey().toString() );
            displayBuffer.append( " " );
            displayBuffer.append( weight.getValue().toString() + "\n" );
        }  //--- while hasNext
    }  //--- displaySimilarityWeights

}  //--- CLASS: QueryWindow