package pcshoppingassistant;

public class DataBreakdownForBooleanTrait extends DataBreakdownForTrait {
    protected final String TRUE_KEY  = String.valueOf(true);
    protected final String FALSE_KEY = String.valueOf(false);

//--------------------
//--- Constructors ---
//--------------------
    public DataBreakdownForBooleanTrait(String traitName) {
        super(traitName);

        BreakPoint breakPoint = new BreakPoint();
        breakPoint.setName(TRUE_KEY);
        breakPoint.setValue(TRUE_KEY);
        this. addBreakPoint(breakPoint);

        breakPoint = new BreakPoint();
        breakPoint.setName(FALSE_KEY);
        breakPoint.setValue(FALSE_KEY);
        this. addBreakPoint(breakPoint);
    }


//---------------
//--- Methods ---
//---------------
    public void addDataPoint(String value) {
        try {
            //--- It would be nice if we were passed "True" or "False",
            //---   but the data coming in from the data files can be all
            //---   sorts of types - whatever the user feels like, really
            //--- So we need to do a little clean up
            //--- If they send us bad data we don't clean up, it'll default to false
            if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("t")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("n") || value.equalsIgnoreCase("f")) {
                value = "false";
            }
            Boolean typeCheck = new Boolean(value);
            String key = typeCheck.toString();

            BreakPoint breakPoint = (BreakPoint) breakPoints.get(key);
            breakPoint.incrementCount();

            totalNumberOfItems++;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }  //--- addDataPoint
}  //--- DataBreakdownForBooleanTrait