package pcshoppingassistant;

import java.util.*;

public class DataBreakdownForNumericTrait extends DataBreakdownForTrait {
//------------------
//--- Attributes ---
//------------------
    private float min = 0;
    private float max = 0;
    private int stepIncrement = 0;


//--------------------
//--- Constructors ---
//--------------------
    public DataBreakdownForNumericTrait(String traitName) {
        super(traitName);
    }


//---------------
//--- Methods ---
//---------------
    public void addDataPoint(String value) {
        try {
            //--- Convert the string to a float
            float numericValue = Float.parseFloat(value);

            //--- First we need to round the item to the proper breakpoint
            int percentage = getPercentageForValue(numericValue);
            String key = Integer.toString(percentage);
            //--- Pad to 3 characters 'cause keys are padded for sorting purposes
            if (key.length()==1)
                key = "  " + key;
            if (key.length()==2)
                key = " " + key;

            BreakPoint breakPoint = (BreakPoint) breakPoints.get(key);
            breakPoint.incrementCount();

            totalNumberOfItems++;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }  //--- addDataPoint


    public void createPercentageBreakPoints(float min, float max, int stepIncrement) {
        try {
            setMin(min);
            setMax(max);
            setStepIncrement(stepIncrement);

            //--- Clear out anything we might already have in our breakpoint collection
            //--- Also makes sure the thing ain't null
            breakPoints = new HashMap();

            //--- Create breakpoints for max and min. We could generate
            //---   them later in our for loop, but this way makes sure
            //---   we don't have any funny rounding errors
            BreakPoint breakPoint = new BreakPoint();
            breakPoint.setName("  0");
            breakPoint.setValue(Float.toString(min));
            this.addBreakPoint(breakPoint);

            breakPoint = new BreakPoint();
            breakPoint.setName("100");
            breakPoint.setValue(Float.toString(max));
            this.addBreakPoint(breakPoint);

            //--- We now have two breakpoints - min and max (0% and 100%)
            //--- Now let's generate the middle breakpoints
            for (int percentage=getStepIncrement();
                 percentage<100;
                 percentage+=getStepIncrement()) {
                float valueAtBreakPoint = getValueAtPercentage(percentage);

                breakPoint = new BreakPoint();
                breakPoint.setName(" " + percentage);
                breakPoint.setValue(Float.toString(valueAtBreakPoint));
                this.addBreakPoint(breakPoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }  //--- createPercentageBreakPoints


    public BreakPoint getBreakpointByPercentile(int percentile) {
        String key = Integer.toString(percentile);

        BreakPoint breakPoint = null;
        if (breakPoints.containsKey(key)) {
            breakPoint = (BreakPoint) breakPoints.get(key);
        }
        return breakPoint;
    }

    protected float getDelta() {
        float delta = (getRange() / getNumberOfSteps());
        return delta;
    }

    public float getMax() {
        return max;
    }
    protected void setMax(float largestValue) {
        max = largestValue;
    }

    public float getMin() {
        return min;
    }
    protected void setMin(float smallestValue) {
        min = smallestValue;
    }

    public int getNumberOfSteps() {
        return (100/stepIncrement)+1;
    }


    protected int getPercentageForValue(float value) {
        if (value==min)
            return 0;
        if (value==max)
            return 100;

        int step = Math.round((value-getMin()) / getDelta());
        int percentagePoint = step * getStepIncrement();

        return percentagePoint;
    }

    public float getRange() {
        float range = (getMax() - getMin());
        return range;
    }

    public int getStepIncrement() {
        return stepIncrement;
    }

    public float getValueAtPercentage(int percentage) {
        if (percentage==0)
            return getMin();
        if (percentage==100)
            return getMax();

        float delta = getDelta();
        int step = percentage/stepIncrement;    // Ex. - 80%/10% = 8
        float stepValue = (step * delta) + min; // Ex. - 0-10, d=1, (1*8)+0 = 8

        return stepValue;
    }  //--- getValueAtPercentage


    protected void setStepIncrement(int stepIncrement) {
        this.stepIncrement = stepIncrement;
    }

}  //--- DataBreakdownForNumericTrait