package pcshoppingassistant;

import java.util.*;

public abstract class DataBreakdownForTrait {
//------------------
//--- Attributes ---
//------------------
    protected HashMap breakPoints = new HashMap();
    protected int totalNumberOfItems = 0;
    protected String traitName = "";


//--------------------
//--- Constructors ---
//--------------------
    public DataBreakdownForTrait(String traitName) {
        this.traitName = traitName;
    }


//---------------
//--- Methods ---
//---------------
    /**
     * Visibility: package/friend (stupid Java default visibility)
     */
    void addBreakPoint(BreakPoint breakPoint) {
        String key = getKey(breakPoint);
        breakPoints.put(key, breakPoint);
    }

    public abstract void addDataPoint(String value);

    public BreakPoint getBreakPoint(String key) {
        BreakPoint breakPoint = null;
        if (breakPoints.containsKey(key)) {
            breakPoint = (BreakPoint) breakPoints.get(key);
        }

        return breakPoint;
    }

    public HashMap getBreakPoints() {
        return breakPoints;
    }

    public int getDataSetSize() {
        return totalNumberOfItems;
    }

    public String getKey(BreakPoint breakPoint) {
        String key = breakPoint.getName();
        return key;
    }

    public String getName() {
        return traitName;
    }

    public Iterator keyIterator() {
        return breakPoints.keySet().iterator();
    }

    public Iterator iterator() {
        //--- HashMap has no Iterator so gotta return something else
        //--- entrySet returns a Collection of Map.Entry objects
        //--- entry.getKey() = HashMap key (String)
        //--- entry.getValue() = a BreakPoint
        return breakPoints.entrySet().iterator();
    }

}  //--- DataBreakdownForTrait