package pcshoppingassistant;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:        PCShoppingAssistant
 * Description:  This Java application assists customers shopping for personal computers at a fictional computer retailer.
 * There are several goals for this project. The first is to build a sample application illustrating the use of The SelectionEngine, a set of Java case based reasoning (CBR) components written by baylor wetzel and provided as open source software at http://selectionengine.sourceforge.net. The second goal is to analyze the functional needs of a real world application as it relates to CBR and to verify that the SelectionEngine CBR system provides the needed functions. That is, the SelectionEngine CBR system was tailored to the application's needs rather than creating an application based on the tool's capabilities. Third, this application is intended to show how CBR can be used in real world applications. The focus of this goal is to show that CBR is easy to use, easy to understand, makes sense for every day applications and is not the difficult, specialized, exotic technology that most business developers believe all AI technologies to be. The fourth goal is to show how AI can be used in the retail world
 * This application was created by baylor wetzel, computer science MS student, for CSIS 636T Artificial Intelligence and Expert Systems II, Fall 2001, University of St Thomas Graduate Programs in Software.
 * Copyright:    Copyright (c) 2001
 * Company:      University of St Thomas
 * @author baylor wetzel
 * @version 1.0
 */

public class MainWindow extends JFrame {
    JButton startUserExperienceButton = new JButton();
    JButton viewDataButton = new JButton();
    JButton settingsButton = new JButton();
    JButton exitButton = new JButton();
    GridLayout gridLayout1 = new GridLayout();

    public MainWindow() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        startUserExperienceButton.setText("Start the user experience...");
        startUserExperienceButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                startUserExperienceButton_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(gridLayout1);
        viewDataButton.setToolTipText("");
        viewDataButton.setText("Batch Run...");
        viewDataButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                viewDataButton_actionPerformed(e);
            }
        });
        this.setDefaultCloseOperation(3);
        this.setTitle("PC Shopping Assistant");
        settingsButton.setText("Settings...");
        settingsButton.setEnabled(false);
        settingsButton.setToolTipText("");
        exitButton.setText("Exit");
        exitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitButton_actionPerformed(e);
            }
        });
        exitButton.setToolTipText("");
        gridLayout1.setRows(4);
        gridLayout1.setColumns(1);
        this.getContentPane().add(startUserExperienceButton, null);
        this.getContentPane().add(viewDataButton, null);
        this.getContentPane().add(settingsButton, null);
        this.getContentPane().add(exitButton, null);
    }

    void viewDataButton_actionPerformed(ActionEvent e) {
        int x=150, y=100, width=800, height=600;

        BatchWindow batchWindow = new BatchWindow();
        batchWindow.setBounds(x,y,width,height);
        batchWindow.show();
    }

    void exitButton_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    void startUserExperienceButton_actionPerformed(ActionEvent e) {
        try {
            int x=250, y=100, width=600, height=600;

            QueryWindow welcomeScreen = new QueryWindow();
            welcomeScreen.setLocation(x,y);
            welcomeScreen.setSize(width,height);
            welcomeScreen.show();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}