package pcshoppingassistant;

import javax.swing.*;
import java.awt.*;
import java.util.*;     //--- Set/Collection stuff, Iterator
import net.sourceforge.selectionengine.*;


/**
 * Title:        PCShoppingAssistant
 * Description:  This Java application assists customers shopping for personal computers at a fictional computer retailer.
 * There are several goals for this project. The first is to build a sample application illustrating the use of The SelectionEngine, a set of Java case based reasoning (CBR) components written by baylor wetzel and provided as open source software at http://selectionengine.sourceforge.net. The second goal is to analyze the functional needs of a real world application as it relates to CBR and to verify that the SelectionEngine CBR system provides the needed functions. That is, the SelectionEngine CBR system was tailored to the application's needs rather than creating an application based on the tool's capabilities. Third, this application is intended to show how CBR can be used in real world applications. The focus of this goal is to show that CBR is easy to use, easy to understand, makes sense for every day applications and is not the difficult, specialized, exotic technology that most business developers believe all AI technologies to be. The fourth goal is to show how AI can be used in the retail world
 * This application was created by baylor wetzel, computer science MS student, for CSIS 636T Artificial Intelligence and Expert Systems II, Fall 2001, University of St Thomas Graduate Programs in Software.
 * Copyright:    Copyright (c) 2001
 * Company:      University of St Thomas
 * @author baylor wetzel
 * @version 1.0
 */

public class ResultsWindow extends JFrame {
    SimilarItems items = null;

    JEditorPane resultsEditorPane = new JEditorPane();

    public ResultsWindow() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        resultsEditorPane.setEditable(false);
        resultsEditorPane.setContentType("text/html");
        this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        this.setTitle("Best Bets");
        this.getContentPane().add(resultsEditorPane, BorderLayout.CENTER);
    }


    /**
      * This is where we display ranked and sorted results
      */
    public void displayResults( JEditorPane displayBuffer,
                                TraitDescriptors traitDescriptors,
                                SimilarItems items ) {
        try {
            StringBuffer HTML = new StringBuffer();

            HTML.append("<table border=0 cellspacing=0 cellpadding=3>");

            //--- Column headers
            HTML.append("<tr>");
            HTML.append("<th><u>Rank</u></th><th><u>Similarity</u></th>");

            for (int i=0; i < traitDescriptors.size(); i++ ) {
                //--- What trait do we want to see the value for?
                TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                String traitName = traitDescriptor.getName();

                String align = "";
                switch (traitDescriptor.getDataType()) {
                    case TraitDescriptor.TYPE_BOOLEAN:
                        align = "align=center";
                        break;
                    case TraitDescriptor.TYPE_STRING:
                        align = "align=left";
                        break;
                    case TraitDescriptor.TYPE_INTEGER:
                    case TraitDescriptor.TYPE_FLOAT:
                        align = "align=right";
                        break;
                }

                HTML.append("<th " + align + "><u>");
                HTML.append( traitName );
                HTML.append("</u></th>");
            }  //--- for i=0 to fields.size
            HTML.append("</tr>");


            //--- Print off each item
            Iterator cursor = items.iterator();
            while (cursor.hasNext()) {
                SimilarityDescription similarityDescription =
                    (SimilarityDescription) cursor.next();
                int percentSimilarity =
                    (int) (100 * similarityDescription.getPercentSimilarity());
                int rank = similarityDescription.getRank();
                Item item = similarityDescription.getItem();

                HTML.append("<tr>");

                HTML.append("<td>");
                HTML.append( rank + ". " );
                HTML.append("</td>");
                HTML.append("<td align=right>");
                HTML.append( percentSimilarity + "%" );
                HTML.append("</td>");

                //--- Which trait should we print a value for?
                //--- Let's print all of them out in the same order as they're
                //---   stored in TraitDescriptors
                for (int i=0; i < traitDescriptors.size(); i++ ) {
                    //--- What trait do we want to see the value for?
                    TraitDescriptor traitDescriptor = traitDescriptors.get( i );
                    String traitName = traitDescriptor.getName();

                    String align = "";
                    switch (traitDescriptor.getDataType()) {
                        case TraitDescriptor.TYPE_BOOLEAN:
                            align = "align=center";
                            break;
                        case TraitDescriptor.TYPE_STRING:
                            align = "align=left";
                            break;
                        case TraitDescriptor.TYPE_INTEGER:
                        case TraitDescriptor.TYPE_FLOAT:
                            align = "align=right";  //--- could sprintf for formatting
                            break;
                    }

                    //--- Let's get that trait in the current item
                    String value = item.getTraitValue( traitName ).value();

                    HTML.append("<td " + align + ">");
                    HTML.append( value );
                    HTML.append("</td>");
                }  //--- for i=0 to fields.size

                HTML.append( "</tr>" );
            }  //--- while hasNext
            HTML.append("</table>");


            //--- Show our results
            displayBuffer.setText(HTML.toString());
        }
        catch (Exception e) {
            System.out.println( "Exception: " + e );
            e.printStackTrace();
        }  //--- catch
    }  //--- displayResults


    public void setResults(SimilarItems items, TraitDescriptors traitDescriptors) {
        this.items = items;

        displayResults(resultsEditorPane, traitDescriptors, items);
    }  //--- setResults

}  //--- ResultsWindow
