package pcshoppingassistant;

import java.awt.*;
import javax.swing.*;

/**
 * Title:        PCShoppingAssistant
 * Description:  This Java application assists customers shopping for personal computers at a fictional computer retailer.
 * There are several goals for this project. The first is to build a sample application illustrating the use of The SelectionEngine, a set of Java case based reasoning (CBR) components written by baylor wetzel and provided as open source software at http://selectionengine.sourceforge.net. The second goal is to analyze the functional needs of a real world application as it relates to CBR and to verify that the SelectionEngine CBR system provides the needed functions. That is, the SelectionEngine CBR system was tailored to the application's needs rather than creating an application based on the tool's capabilities. Third, this application is intended to show how CBR can be used in real world applications. The focus of this goal is to show that CBR is easy to use, easy to understand, makes sense for every day applications and is not the difficult, specialized, exotic technology that most business developers believe all AI technologies to be. The fourth goal is to show how AI can be used in the retail world
 * This application was created by baylor wetzel, computer science MS student, for CSIS 636T Artificial Intelligence and Expert Systems II, Fall 2001, University of St Thomas Graduate Programs in Software.
 * Copyright:    Copyright (c) 2001
 * Company:      University of St Thomas
 * @author baylor wetzel
 * @version 1.0
 */

public class WelcomeScreen extends JFrame {
    JButton goToQueryScreenButton = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();

    public WelcomeScreen() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        goToQueryScreenButton.setText("Tell us what you\'re looking for!");
        goToQueryScreenButton.setBounds(new Rectangle(99, 90, 210, 38));
        this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        this.setResizable(false);
        this.setTitle("Welcome to Crazy baylor\'s PC Super Store!!!");
        this.getContentPane().setLayout(null);
        jLabel1.setText("You\'ve come to the right place!");
        jLabel1.setBounds(new Rectangle(10, 9, 246, 23));
        jLabel2.setText("Best service! Best Prices! Your trusted friend in the computer business!");
        jLabel2.setBounds(new Rectangle(9, 26, 406, 23));
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabel2, null);
        this.getContentPane().add(goToQueryScreenButton, null);
    }
}