package pcshoppingassistant.uitools;

import javax.swing.JPanel;
import javax.swing.*;
import net.sourceforge.selectionengine.TraitDescriptor; //--- trait data types


/**
 * Title:        TraitPanel
 * Description:  JPanel doesn't have an ActionCommand or Tag or any place
 *                  to store info. To be able to dynamically create
 *                  a UI for the PCShoppingAssistant application, i want to be
 *                  able to ask a panel what trait it represents. i'd also like
 *                  to know the button groups in it so i can extract values.
 *                  And knowing the data type of the trait it represents would
 *                  be pretty useful
 * Copyright:    Copyright (c) 2001
 * Company:      University of St Thomas
 * @author baylor wetzel
 * @version 1.0
 */

public class TraitPanel extends JPanel {
//---------------------------------------------------------------------------
//--- Attributes
//---------------------------------------------------------------------------
    protected JCheckBox filterCheckBox = null;
    protected JComboBox filterOperatorComboBox = null;
    protected JComboBox filterValueComboBox = null;
    protected JComboBox preferenceValueComboBox = null;
    protected JCheckBox similarityCheckBox = null;
    protected int traitDataType = TraitDescriptor.TYPE_UNKNOWN;
    protected String traitName = "";
    protected ButtonGroup valueButtonGroup = null;
    protected ButtonGroup weightButtonGroup = null;


//---------------------------------------------------------------------------
//--- Constructors
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//--- Public Methods
//---------------------------------------------------------------------------
    public JCheckBox getFilterCheckBox() {
        return filterCheckBox;
    }
    public void setFilterCheckBox(JCheckBox filterCheckBox) {
        this.filterCheckBox = filterCheckBox;
    }

    public JCheckBox getSimilarityCheckBox() {
        return similarityCheckBox;
    }
    public void setSimilarityCheckBox(JCheckBox preferCheckBox) {
        this.similarityCheckBox = preferCheckBox;
    }

    public String getTraitName() {
        return traitName;
    }
    public void setTraitName(String name) {
        this.traitName = name;
    }

    public int getTraitDataType() {
        return traitDataType;
    }
    public void setTraitDataType(int dataType) {
        //--- The only meaningful values are
        //--- TYPE_BOOLEAN, TYPE_FLOAT, TYPE_INTEGER and TYPE_STRING

        this.traitDataType = dataType;
    }

    public JComboBox getFilterOperatorComboBox() {
        return filterOperatorComboBox;
    }
    public void setFilterOperatorComboBox(JComboBox list) {
        filterOperatorComboBox = list;
    }

    public String getFilterOperator() {
        String value = null;

        try {
            switch (traitDataType) {
                case TraitDescriptor.TYPE_INTEGER:
                case TraitDescriptor.TYPE_FLOAT:
                case TraitDescriptor.TYPE_STRING:
                    JComboBox list = getFilterValueComboBox();
                    value = list.getSelectedItem().toString();
                    break;

                case TraitDescriptor.TYPE_BOOLEAN:
                    value = "=";    //--- Always
                    break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return value;
    }  //--- getFilterOperator


    public String getFilterValue() {
        String value = null;

        try {
            switch (traitDataType) {
                case TraitDescriptor.TYPE_INTEGER:
                case TraitDescriptor.TYPE_FLOAT:
                case TraitDescriptor.TYPE_STRING:
                    JComboBox list = getFilterValueComboBox();
                    value = list.getSelectedItem().toString();
                    break;

                case TraitDescriptor.TYPE_BOOLEAN:
                    JComboBox preferenceList = getPreferenceValueComboBox();
                    value = preferenceList.getSelectedItem().toString();
                    break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return value;
    }  //--- getFilterValue

    public JComboBox getFilterValueComboBox() {
        return filterValueComboBox;
    }
    public void setFilterValueComboBox(JComboBox list) {
        filterValueComboBox = list;
    }


    public String getPreferenceValue() {
        String value = null;

        try {
            switch (traitDataType) {
                case TraitDescriptor.TYPE_INTEGER:
                case TraitDescriptor.TYPE_FLOAT:
                    ButtonGroup radioButtons = getValueButtonGroup();
                    value = radioButtons.getSelection().getActionCommand();
                    break;

                case TraitDescriptor.TYPE_BOOLEAN:
                case TraitDescriptor.TYPE_STRING:
                    JComboBox list = getPreferenceValueComboBox();
                    value = list.getSelectedItem().toString();
                    break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return value;
    }

    //--- Only applies if the trait is numeric, not strings or booleans
    public ButtonGroup getValueButtonGroup() {
        return valueButtonGroup;
    }
    public void setValueButtonGroup(ButtonGroup group) {
        valueButtonGroup = group;
    }

    //--- Only applies if the trait is string or boolean
    public JComboBox getPreferenceValueComboBox() {
        return preferenceValueComboBox;
    }
    public void setPreferenceValueComboBox(JComboBox list) {
        this.preferenceValueComboBox = list;
    }


    public ButtonGroup getWeightButtonGroup() {
        return weightButtonGroup;
    }
    public void setWeightButtonGroup(ButtonGroup group) {
        weightButtonGroup = group;
    }

    public int getWeight() {
        int weight = 0;

        try {
            ButtonGroup radioButtons = getWeightButtonGroup();
            String actionCommand = radioButtons.getSelection().getActionCommand().trim();
            weight = Integer.parseInt(actionCommand);
        }
        catch (Exception e) {
            //--- If we have a problem, return a weight of 0
            //--- A 0 weight is like not having this criteria at all
            System.out.println("TraitPanel::getWeight: " + e);
        }

        return weight;
    }

    public boolean hasFilterCriteria() {
        boolean hasFilterCriteria = false;

        try {
            JCheckBox checkBox = getFilterCheckBox();
            hasFilterCriteria = checkBox.isSelected();
        }
        catch (Exception e) {
            System.out.println("Exception: filterCheckBox for TraitPanel not set");
        }

        return hasFilterCriteria;
    }  //--- hasFilterCriteria

    public boolean hasSimilarityCriteria() {
        boolean hasSimilarityCriteria = false;

        try {
            JCheckBox checkBox = getSimilarityCheckBox();
            hasSimilarityCriteria = checkBox.isSelected();
        }
        catch (Exception e) {
            System.out.println("Exception: similarityCheckBox for TraitPanel not set");
        }

        return hasSimilarityCriteria;
    }  //--- hasSimilarityCriteria


//---------------------------------------------------------------------------
//--- Protected Methods
//---------------------------------------------------------------------------

}  //--- TraitPanel