package temp;



/**

 *

 * @author <small>baylor</small>

 *

 */

public class FilterCriterion

{



//-----------------------------------------------------------------------------

// Public constants

//-----------------------------------------------------------------------------

    public static final int OPERATOR_UNKNOWN               = 0;

    public static final int OPERATOR_EQUALS                = 1;

    public static final int OPERATOR_NOT_EQUAL             = 2;

    public static final int OPERATOR_GREATER_THAN          = 3;

    public static final int OPERATOR_GREATER_THAN_OR_EQUAL = 4;

    public static final int OPERATOR_LESS_THAN             = 5;

    public static final int OPERATOR_LESS_THAN_OR_EQUAL    = 6;



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

    protected String fieldName;

    protected int operator;

    protected TraitValue value;



//-----------------------------------------------------------------------------

// Constructors

//-----------------------------------------------------------------------------

    protected FilterCriterion( String fieldName, String operator, String value ) {

        this.fieldName = fieldName;

        this.operator = stringToOperator( operator );

        this.value = new TraitValue( value );

    }  //--- constructor



//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

    public String getFieldName() {

        return fieldName;

    }



    public int getOperator() {

        return operator;

    }



    public String getOperatorAsString() {

        return operatorToString( operator );

    }



    public TraitValue getValue() {

        return value;

    }





    public boolean itemViolates(  Item item ) {

        boolean violationFound = true;



        int type = item.getTraitDataType( this.getFieldName() );

        int operator = this.getOperator();

        TraitValue itemValue = item.getTraitValue( this.getFieldName() );



        //--- Ugly messy code

        //--- Switch statements aren't great, nested ones are a sure sign

        //---   that someone (like me) didn't think this through very well

        //--- Better fix this once i get this out of the quick and dirty stage

        switch( operator ) {

            case OPERATOR_EQUALS:

                switch( type ) {

                    case TraitDescriptor.TYPE_BOOLEAN:

                        violationFound = (! (itemValue.toBoolean() == this.value.toBoolean()) );

                        break;

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() == this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() == this.value.toInteger()) );

                        break;

                    case TraitDescriptor.TYPE_STRING:

                        violationFound = (! (this.value.toString().equals(itemValue.toString())) );

                        break;

                }



                break;



            case OPERATOR_NOT_EQUAL:

                switch( type ) {

                    case TraitDescriptor.TYPE_BOOLEAN:

                        violationFound = (! (itemValue.toBoolean() != this.value.toBoolean()) );

                        break;

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() != this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() != this.value.toInteger()) );

                        break;

                    case TraitDescriptor.TYPE_STRING:

                        violationFound = (this.value.toString().equals(itemValue.toString()));

                        break;

                }



                break;



            case OPERATOR_GREATER_THAN:

                switch( type ) {

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() > this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() > this.value.toInteger()) );

                        break;

                }



                break;



            case OPERATOR_GREATER_THAN_OR_EQUAL:

                switch( type ) {

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() >= this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() >= this.value.toInteger()) );

                        break;

                }



                break;



            case OPERATOR_LESS_THAN:

                switch( type ) {

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() < this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() < this.value.toInteger()) );

                        break;

                }



                break;



            case OPERATOR_LESS_THAN_OR_EQUAL:

                switch( type ) {

                    case TraitDescriptor.TYPE_FLOAT:

                        violationFound = (! (itemValue.toFloat() <= this.value.toFloat()) );

                        break;

                    case TraitDescriptor.TYPE_INTEGER:

                        violationFound = (! (itemValue.toInteger() <= this.value.toInteger()) );

                        break;

                }



                break;

        }  //--- switch( operator )



        return violationFound;

    }  //--- itemViolates





    private String operatorToString( int operator ) {

        String stringValue = null;



        if (operator == OPERATOR_EQUALS) {

            stringValue = "=";

        } else

        if (operator == OPERATOR_NOT_EQUAL) {

            stringValue = "!=";

        } else

        if (operator == OPERATOR_GREATER_THAN) {

            stringValue = ">";

        } else

        if (operator == OPERATOR_GREATER_THAN_OR_EQUAL) {

            stringValue = ">=";

        } else

        if (operator == OPERATOR_LESS_THAN) {

            stringValue = "<";

        } else

        if (operator == OPERATOR_LESS_THAN_OR_EQUAL) {

            stringValue = "<=";

        } //--- figure out the operator



        return stringValue;

    }  //--- operatorToString





    private int stringToOperator( String operator ) {

        int numericValue = OPERATOR_UNKNOWN;



        if (operator.equals( "=" )) {

            numericValue = OPERATOR_EQUALS;

        } else

        if (operator.equals( "!=" )) {

            numericValue = OPERATOR_NOT_EQUAL;

        } else

        if (operator.equals( ">" )) {

            numericValue = OPERATOR_GREATER_THAN;

        } else

        if (operator.equals( ">=" )) {

            numericValue = OPERATOR_GREATER_THAN_OR_EQUAL;

        } else

        if (operator.equals( "<" )) {

            numericValue = OPERATOR_LESS_THAN;

        } else

        if (operator.equals( "<=" )) {

            numericValue = OPERATOR_LESS_THAN_OR_EQUAL;

        } //--- figure out the operator



        return numericValue;

    }  //--- stringToDataType



}  //--- FilterCriterion

