package temp;

import java.io.*;

/**
 *
 */
public class ItemManager {
    private static final String FIELD_LINE_INDICATOR   = "f";
    private static final String DATA_LINE_INDICATOR    = "d";
    private static final String DEFAULT_FILE_NAME = "data.txt";


    //--- Static for performance. i don't want to have each instance
    //---   of this load its own data from the data source
    private static TraitDescriptors traitDescriptors = new TraitDescriptors();
    private static Items items = new Items( traitDescriptors );


    public ItemManager( ) {
        init();
    }


    public Items getItems() {
        return items;
    }


    public TraitDescriptors getTraitDescriptors() {
        return traitDescriptors;
    }


    private void init() {
        loadItems();
    }


    /************************************************************************
     *
     ************************************************************************/
    protected void loadItems() {
        //--- If we've already loaded everything, don't bother doing so again
        if (items.size() != 0) {
            return;
        }


        try {
            String fileName = DEFAULT_FILE_NAME;

            BufferedReader in = new BufferedReader( new FileReader(fileName) );
            String line;

            //--- Read all the lines in
            while ((line = in.readLine()) != null) {

                //--- What type of string is this?
                //--- We can tell from the first character
                String lineType = null;
                if (line.length() != 0) {
                    lineType = line.substring(0,1);
                } else {
                    //--- Gotta make this something so that we don't get a null
                    //---   object error later on
                    lineType = "";
                }

                //--- We're only going to work with data and field definition lines
                if (!(lineType.equalsIgnoreCase( FIELD_LINE_INDICATOR )) &&
                    !(lineType.equalsIgnoreCase( DATA_LINE_INDICATOR  ))) {
                    continue;
                }


                //--- OK, we got a string in a format similar to
                //---   D=val1|val2|val3 or
                //---   F=s:val1|i:val2|f:val3|b:val4
                //--- Let's get rid of the tag and = sign
                int equalSignPosition = line.indexOf( '=' );
                line = line.substring( equalSignPosition + 1 );


                //--- We want to take the data and put it into the fields
                //---   we have set up
                //--- So if we haven't found any fields yet, we can't do anything
                //---   with the data lines
                if (traitDescriptors.isEmpty()) {
                    if (!(lineType.equalsIgnoreCase( FIELD_LINE_INDICATOR ))) {
                        continue;
                    }  //--- field_line_indicator
                }  //--- traitDescriptors.isEmpty



                //--- We have a field definition line
                if (lineType.equalsIgnoreCase( FIELD_LINE_INDICATOR )) {
                    //--- Make sure we haven't already processed a field definition line
                    if (!(traitDescriptors.isEmpty())) {
                        //--- Oops, someone's trying to sneak an extra definition row in here
                        //--- Let's just skip this row
                        continue;
                    }  //--- field_line_indicator


                    traitDescriptors.loadFromDelimitedString( line );

                }  //--- lineType = field


                //--- We got a line of data
                if (lineType.equalsIgnoreCase( DATA_LINE_INDICATOR )) {
                    items.add( getTraitDescriptors(), line );
                }  //--- lineType = data

            }  //--- while in.readLine

            in.close();

        }  //--- try
        catch (Exception e) {
            String methodName = "ItemManager::loadItems";
            System.out.println( methodName + " error: " + e );
        }  //--- catch
    }  //--- loadItems
}