package temp;





public class SimilarityCriterion

{



//-----------------------------------------------------------------------------

// Public constants

//-----------------------------------------------------------------------------

    public static final int OPERATOR_UNKNOWN		= 0;

    public static final int OPERATOR_SIMILAR		= 1;

    public static final int OPERATOR_NOT_SIMILAR	= 2;

    public static final int OPERATOR_AROUND			= 3;



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

    private String     fieldName;

    private int        operator;

    private TraitValue value;



//-----------------------------------------------------------------------------

// Constructors

//-----------------------------------------------------------------------------

    protected SimilarityCriterion( String fieldName, String operator, String value )

    {

        this.fieldName = fieldName;

        this.operator  = stringToOperator( operator );

        this.value     = new TraitValue( value );

    }



//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

    private String operatorToString( int operator )

    {

        String stringValue = null;



        if (operator == OPERATOR_SIMILAR) {

            stringValue = "%";

        }

        else if (operator == OPERATOR_NOT_SIMILAR) {

            stringValue = "!%";

        }

        else if (operator == OPERATOR_AROUND) {

            stringValue = "~";

        } //--- figure out the operator



        return stringValue;

    }  //--- operatorToString





    private int stringToOperator( String operator )

    {

        int numericValue = OPERATOR_UNKNOWN;



        if (operator.equals( "%" )) {

            numericValue = OPERATOR_SIMILAR;

        }

        else if (operator.equals( "!%" )) {

            numericValue = OPERATOR_NOT_SIMILAR;

        }

        else if (operator.equals( "~" )) {

            numericValue = OPERATOR_AROUND;

        } //--- figure out the operator



        return numericValue;

    }  //--- stringToDataType





//-----------------------------------------------------------------------------

// Accessors

//-----------------------------------------------------------------------------

    public String getFieldName()

    {

        return this.fieldName;

    }



    public String getID()

    {

        return "[" + fieldName + "|" + getOperatorAsString() + "|" + value + "]";

    }



    public int getOperator()

    {

        return this.operator;

    }



    public String getOperatorAsString()

    {

        return operatorToString( this.operator );

    }



    public TraitValue getValue()

    {

        return this.value;

    }



}  //--- SimilarityCriterion

