package temp;



/**

 * This class is the meta data for the traits

 * That means the trait name and data type

 */

public class TraitDescriptor {

    //--- Public constants

    public static final int TYPE_UNKNOWN = 0;

    public static final int TYPE_BOOLEAN = 1;

    public static final int TYPE_FLOAT   = 2;

    public static final int TYPE_INTEGER = 3;

    public static final int TYPE_STRING  = 4;



//-----------------------------------------------------------------------------



    //--- Private constants

    private static final String BOOLEAN_ABBREVIATION = "b";

    private static final String FLOAT_ABBREVIATION   = "f";

    private static final String INTEGER_ABBREVIATION = "i";

    private static final String STRING_ABBREVIATION  = "s";



//-----------------------------------------------------------------------------



    //--- Attributes

    private String name = null;

    private int dataType = TYPE_UNKNOWN;



//-----------------------------------------------------------------------------



    TraitDescriptor( String encodedData ) {

        loadFromDelimitedString( encodedData );

    }  //--- constructor





//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

    public int getDataType() {

        return dataType;

    }





    public String getName() {

        return name;

    }





    public void loadFromDelimitedString( String encodedData ) {

        try {

            //--- encodedData will be in the format

            //---   s:val

            //--- where the first character is the data type,

            //---   the second character is the delimiter

            //---   and the rest is the field name



            //--- Trim the spaces off the data they passed us

            String field = encodedData.trim();



            //--- The name is in positions 3-string length

            //--- Position 1 is the datatype and 2 is the delimiter

            name = field.substring(2).trim();



            //--- Convert the datatype character to a known constant

            //---   for that type

            String dataTypeAbbreviation = field.substring(0,1).toLowerCase();

            dataType = stringToDataType( dataTypeAbbreviation );

        }  //--- try



        catch (Exception e) {

            String methodName = "Trait::loadFromDelimitedString";

            System.out.println( methodName + " error: " + e );

        }  //--- catch

    }  //--- loadFromDelimitedString





    private int stringToDataType( String dataType ) {

        int numericValue = TYPE_UNKNOWN;



        if (dataType.equals( BOOLEAN_ABBREVIATION )) {

            numericValue = TYPE_BOOLEAN;

        } else

        if (dataType.equals( FLOAT_ABBREVIATION )) {

            numericValue = TYPE_FLOAT;

        } else

        if (dataType.equals( INTEGER_ABBREVIATION )) {

            numericValue = TYPE_INTEGER;

        } else

        if (dataType.equals( STRING_ABBREVIATION )) {

            numericValue = TYPE_STRING;

        } //--- figure out the datatype



        return numericValue;

    }  //--- stringToDataType





    public String toString( ) {

        return getName();

    }

}  //--- TraitDescriptor

