package temp;



/**

 * The TraitStatistics class contains statistical info

 *   about the various values for a single, specific trait.

 *   That includes the max value, min value and range

 *

 * This class has two primary purposes.

 * First, we need this info to handle queries that use the variables

 *   [MAX_VALUE] and [MIN_VALUE]

 * Second, we need the min, max and range info to do the

 *   nearest neighbor/similarity calculation

 *

 * Although this should be obvious, this class was only designed

 *   to work with numbers - i don't want to compute degrees of

 *   similarity on strings or booleans

 * When building stats for strings and booleans, min=0 max=1

 *

 * It is believed that DataSetStatistics is the only class

 *   that will instantiate this one. The class was designed

 *   to be contained by DataSetStatistics

 *

 * @author <small>baylor</small>

 *

 */

public class TraitStatistics {



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

    private String traitName;

    private float  minimumValue;

    private float  maximumValue;

    private int    numberOfExamples = 0;



//-----------------------------------------------------------------------------

// Constructors

//-----------------------------------------------------------------------------

    public TraitStatistics( String traitName ) {

        setTraitName( traitName );

    }



//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

    public void addExample( float value ) {

        if (numberOfExamples == 0) {

            this.setMinimumValue( value );

            this.setMaximumValue( value );

        } else {

            if (value < getMinimumValue()) {

                this.setMinimumValue( value );

            }



            if (value > getMaximumValue()) {

                this.setMaximumValue( value );

            }

        }



        numberOfExamples++;

    }  //--- addExample





    public float getMaximumValue() {

        return maximumValue;

    }  //--- getMaximumValue





    public float getMinimumValue() {

        return minimumValue;

    }  //--- getMinimumValue





    public String getTraitName() {

        return traitName;

    }  //--- getTraitName





    public float getRange() {

        return (maximumValue - minimumValue);

    }  //--- getMinimumValue





    protected void setMaximumValue( float value ) {

        maximumValue = value;

    }  //--- setMaximumValue





    protected void setMinimumValue( float value ) {

        minimumValue = value;

    }  //--- setMinimumValue





    protected void setTraitName( String name ) {

        traitName = name;

    }  //--- setTraitName



}  //--- TraitStatistics

