package net.sourceforge.selectionengine;



import java.util.*;



/**

 * @author baylor

 */

public class TraitDescriptors {

	//--- Should probably have the trait and trait descriptors

	//---   act the same for get's and iterator

	ArrayList traitDescriptors = new ArrayList();





	private void add( int index, TraitDescriptor descriptor ) {

		traitDescriptors.add( index, descriptor );

	}  //--- add





	public boolean isEmpty() {

		return traitDescriptors.isEmpty();

	}

	

	

	public Iterator iterator() {

		//--- Returns an iterator to an array list containing

		//---   TraitDescriptor objects

		return traitDescriptors.iterator();

	}  //--- iterator

	

	

	public TraitDescriptor get( int index ) {

		return (TraitDescriptor) traitDescriptors.get( index );

	}  //--- get

	



	public TraitDescriptor get( String traitName ) {

		TraitDescriptor matchingDescriptor = null;

		

		Iterator cursor = traitDescriptors.iterator();

		while (cursor.hasNext()) {

			TraitDescriptor traitDescriptor = (TraitDescriptor) cursor.next();

			

			if (traitDescriptor.getName().equals( traitName )) {

				matchingDescriptor = traitDescriptor;

			}

		}  //--- hasNext

		

		return matchingDescriptor;

	}  //--- getTraitDescriptor

	

	

	public int getDataType( String traitName ) {

		TraitDescriptor traitDescriptor = get( traitName );

		

		return traitDescriptor.getDataType();

	}  //--- getDataType

	



	protected void loadFromDelimitedString(	String encodedData ) {

		try {

			int entryNumber = 0;

		

			//--- Capture all the fields that the user wants to define

			StringTokenizer st = new StringTokenizer(encodedData, "|");

			while (st.hasMoreTokens()) {

				String token = st.nextToken();



				TraitDescriptor traitDescriptor = new TraitDescriptor( token );



				add( entryNumber, traitDescriptor );

	

				entryNumber++;

			}  //--- while st.hasMoreTokens

		}  //--- try

  		catch (Exception e) {

  			String methodName = "TraitDescriptors::loadFromDelimitedString";

  			System.out.println( methodName + " error: " + e );

  		}  //--- catch

	}  //--- loadFromDelimitedString

	



	public int size( ) {

		return traitDescriptors.size();

	}  //--- size

			

}  //--- TraitDescriptors

