package net.sourceforge.selectionengine;



import java.util.*;



/**

 * @author baylor

 */

public class Traits {



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

	private HashMap traits = new HashMap();



//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

	protected void add( Trait newTrait ) {

		String key = newTrait.getName();

		traits.put( key, newTrait );

	}

	



	public Trait get( String traitName ) {

		return (Trait) traits.get( traitName );

	}  //--- get

	

	

	public boolean isEmpty() {

		return traits.isEmpty();

	}



	

	public Iterator iterator() {

		return traits.values().iterator();

	}

	

	

	/**

	 * Load data from a string

	 * The string will have the data fields in the same

	 *   order as the array of field definitions

	 * The string is | delimited

	 */

	protected void loadFromDelimitedString(	TraitDescriptors traitDescriptors, 

											String encodedData ) {

		try {

			int fieldNumber = 0;

			

			//--- Break the string into pieces

			StringTokenizer st = new StringTokenizer(encodedData, "|");

	

			//--- Get each field of data

			while (st.hasMoreTokens()) {

				String key = traitDescriptors.get(fieldNumber).toString();

				String value = st.nextToken().trim();

				

				Trait trait = new Trait( key, value );



				add( trait );

				

				fieldNumber++;

			}  //--- while hasMoreTokens

		}  //--- try

  		catch (Exception e) {

  			e.printStackTrace();

  		}  //--- catch

	}  //--- loadFromDelimitedString

	

}  //--- Traits

