package net.sourceforge.selectionengine;



import java.util.*;



/**

 *

 * @author <small>baylor</small>

 *

 */

public class Items {



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

	ArrayList data = new ArrayList();

	TraitDescriptors traitDescriptors;

	

//-----------------------------------------------------------------------------

// Constructors

//-----------------------------------------------------------------------------

	/**

	 * This is the only constructor and it requires TraitDescriptors

	 * Technically, Items doesn't need to know anything about TraitDescriptors,

	 *   but a lot of the people who use Items (actually, Item) do.

	 *   They could create their own copy, but that would be slow, what with

	 *   all the loading and what not. Ditto for storing it with each Item.

	 *   So storing TraitDescriptors here is just a minor performance tuning thingy

	 */

	protected Items( TraitDescriptors traitDescriptors ) {

		this.traitDescriptors = traitDescriptors;

	}  //--- constructor

	

//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

	protected void add( Item item ) {

		data.add( item );

	}  //--- add



	protected void add( TraitDescriptors traitDescriptors, String encodedData ) {

		Item item = new Item( traitDescriptors );

		

		item.loadFromDelimitedString( traitDescriptors, encodedData );

		

		this.add( item );

	}  //--- add

	

	

	public Object clone( ) {

		Items newItems = new Items( traitDescriptors );

		newItems.setValues( data );

		

		return (Object) newItems;

	}  //--- clone

	

	

	public TraitDescriptors getTraitDescriptors() {

		return traitDescriptors;

	}

	

	

	public Iterator iterator() {

		return data.iterator();

	}

	



	private void setValues( ArrayList newValues ) {

		data = (ArrayList) newValues.clone();

	}





	/**

	 * Number of items in the collection

	 */

	public int size() {

		return data.size();

	}

}  //--- Items