package net.sourceforge.selectionengine;



import java.util.*;



/**

 *

 * @author <small>baylor</small>

 *

 */

public class SimilarityWeights {



//-----------------------------------------------------------------------------

// Attributes

//-----------------------------------------------------------------------------

	private HashMap weights = new HashMap();



//-----------------------------------------------------------------------------

// Methods

//-----------------------------------------------------------------------------

	protected void add( String fieldName, int weight ) {

		//--- HashMaps require objects, no intrinsic data types

		//--- So we gotta convert int to Integer to store it

		Integer weightAsObject = new Integer( weight );

		

		weights.put( fieldName, weightAsObject );

	}  //--- add





	public Object clone( ) {

		SimilarityWeights newItems = new SimilarityWeights();

		newItems.setValues( weights );

		

		return (Object) newItems;

	}  //--- clone





	public int get( String traitName ) {

		Integer value = (Integer) weights.get( traitName );

		return value.intValue();

	}  //--- get

	

	

	public Iterator iterator() {

		return weights.values().iterator();

	}  //--- iterator

	

	public Iterator mapIterator() {

		return weights.entrySet().iterator();

	}  //--- iterator



	private void setValues( HashMap newValues ) {

		weights = (HashMap) newValues.clone();

	}  //--- setValues





	public int size() {

		return weights.size();

	}  //--- size

	

}  //--- SimilarityWeights