package net.sourceforge.selectionengine.testharness;



import net.sourceforge.selectionengine.*;

import java.util.*;





public class FilterEngineTest

{

	

	public static void main( String[] args ) {

		//--- Let's get this party started

		QueryReaderTest q = new QueryReaderTest();

	}

	

	

	public FilterEngineTest() {

		QueryReader queryReader = new QueryReader();

		

		System.out.println( "Filter Criteria" );

		System.out.println( "---------------" );

		displayFilterCriteria( queryReader.getFilterCriteria() );



		System.out.println( "" );

		System.out.println( "Similarity Criteria" );

		System.out.println( "-------------------" );

		displaySimilarityCriteria( queryReader.getSimilarityCriteria() );



		System.out.println( "" );

		System.out.println( "Similarity Weights" );

		System.out.println( "------------------" );

		displaySimilarityWeights( queryReader.getSimilarityWeights() );

		

		//DisplayManager displayManager = new DisplayManager();

		//displayManager.displayItems( );

	}  //--- constructor

	

	

	public void displayFilterCriteria( FilterCriteria filterCriteria ) {

		Iterator cursor = filterCriteria.iterator();	//--- iterator on an ArrayList

		

		while (cursor.hasNext()) {

			FilterCriterion criterion = (FilterCriterion) cursor.next();

		

			System.out.print( criterion.getFieldName() );

			System.out.print( " " );

			System.out.print( criterion.getOperator() );

			System.out.print( " " );

			System.out.println( criterion.getValue() );

		}  //--- while hasNext

	}  //--- displayFilterCriteria

	

	

	public void displaySimilarityCriteria( SimilarityCriteria similarityCriteria ) {

		Iterator cursor = similarityCriteria.iterator();	//--- iterator on an ArrayList

		

		while (cursor.hasNext()) {

			SimilarityCriterion criterion = (SimilarityCriterion) cursor.next();

		

			System.out.print( criterion.getFieldName() );

			System.out.print( " " );

			System.out.print( criterion.getOperator() );

			System.out.print( " " );

			System.out.println( criterion.getValue() );

		}  //--- while hasNext

	}  //--- displaySimilarityCriteria



	

	public void displaySimilarityWeights( SimilarityWeights similarityWeights ) {

		Iterator cursor = similarityWeights.iterator();	//--- iterator on an ArrayList

		

		while (cursor.hasNext()) {

			SimilarityWeight weight = (SimilarityWeight) cursor.next();

		

			System.out.print( weight.getFieldName() );

			System.out.print( " " );

			System.out.println( weight.getWeight() );

		}  //--- while hasNext

	}  //--- displaySimilarityWeights

	

}  //--- QueryReaderTest

